﻿using Microsoft.Extensions.Configuration;
using System.Threading.Tasks;
using VA.PPMS.IWS.Api.Configuration.Interface;

namespace VA.PPMS.IWS.Api.Configuration
{
    public class IwsConfiguration : IIwsConfiguration
    {
        private readonly IConfiguration _configuration;

        public IwsConfiguration(IConfiguration configuration)
        {
            _configuration = configuration;
        }

        public async Task<string> GetFunctionBaseUriAsync()
        {
            return await GetConfigValue("FunctionBaseUri");
        }

        public async Task<string> GetCcnDataStreamUri()
        {
            return await GetConfigValue("CcnDataStreamUri");
        }

        public async Task<string> GetCcnInitialDocRefUri()
        {
            return await GetConfigValue("CcnInitialDocRefUri");
        }

        public async Task<string> GetDasOperationOutcomeUri()
        {
            return await GetConfigValue("DasOperationOutcomeUri");
        }

        public async Task<string> GetPingUri()
        {
            return await GetConfigValue("PingUri");
        }

        public async Task<string> GetPpmsDataStreamUri()
        {
            return await GetConfigValue("PpmsDataStreamUri");
        }

        private async Task<string> GetConfigValue(string configKey)
        {
            await Task.Run(() => { });

            return _configuration[$"IwsSettings:{configKey}"];
        }
    }
}